@echo off
setlocal enabledelayedexpansion

:: =======================
:: Set Paths
:: =======================
set "SCRIPT_DIR=%~dp0"
set "MSI_FILE=%SCRIPT_DIR%OpenJDK21U-jre_x64_windows_hotspot_21.0.9_10.msi"
set "LOG_DIR=%SCRIPT_DIR%logs"
set "LOGFILE=%LOG_DIR%\install-log.txt"
set "MSI_LOG=%LOG_DIR%\msi-install-log.txt"

:: Create log folder
if not exist "%LOG_DIR%" mkdir "%LOG_DIR%"
if exist "%LOGFILE%" del "%LOGFILE%"
if exist "%MSI_LOG%" del "%MSI_LOG%"

echo %DATE% %TIME% - Script started > "%LOGFILE%"

:: =======================
:: Elevation Check
:: =======================
net session >nul 2>&1
if %ERRORLEVEL% neq 0 (
    echo %DATE% %TIME% - Not running as Admin, requesting elevation >> "%LOGFILE%"
    goto UACPrompt
)
goto :ContinueExecution

:UACPrompt
echo %DATE% %TIME% - Triggering UAC prompt >> "%LOGFILE%"
echo Set objShell = CreateObject("Shell.Application") > "%temp%\getadmin.vbs"
echo objShell.ShellExecute "%~s0", "elevated", "", "runas", 1 >> "%temp%\getadmin.vbs"
"%temp%\getadmin.vbs"
del "%temp%\getadmin.vbs"
exit /b

:ContinueExecution
if "%1"=="elevated" shift

echo %DATE% %TIME% - Running with Admin privileges >> "%LOGFILE%"
echo Detected Admin Privileges. Proceeding... >> "%LOGFILE%"

:: =======================
:: MSI Installation
:: =======================
echo Checking for MSI file at: "%MSI_FILE%" >> "%LOGFILE%"
if not exist "%MSI_FILE%" (
    echo MSI file not found at %MSI_FILE% >> "%LOGFILE%"
    echo MSI file not found!
    exit /b 1
)

echo Starting MSI installation... >> "%LOGFILE%"
echo Command: msiexec /i "%MSI_FILE%" ADDLOCAL=FeatureMain,FeatureEnvironment,FeatureJarFileRunWith INSTALLDIR="C:\Program Files\AdoptOpenJDK\" ALLUSERS=1 REBOOT=ReallySuppress /qn /l*v "%MSI_LOG%" >> "%LOGFILE%"

msiexec /i "%MSI_FILE%" ^
    ADDLOCAL=FeatureMain,FeatureEnvironment,FeatureJarFileRunWith ^
    INSTALLDIR="C:\Program Files\AdoptOpenJDK\" ^
    ALLUSERS=1 ^
    REBOOT=ReallySuppress ^
    /qn /l*v "%MSI_LOG%"

set MSI_EXIT_CODE=%ERRORLEVEL%
echo MSIEXEC returned exit code: %MSI_EXIT_CODE% >> "%LOGFILE%"

if %MSI_EXIT_CODE% equ 0 (
    echo MSI installation succeeded. Java is ready. >> "%LOGFILE%"
    goto ShowSuccess
) else (
    echo MSI installation failed with exit code: %MSI_EXIT_CODE% >> "%LOGFILE%"
    echo Installation failed!
    echo Exit Code: %MSI_EXIT_CODE%
    echo Check detailed log: %MSI_LOG%
    exit /b %MSI_EXIT_CODE%
)

:ShowSuccess
echo %DATE% %TIME% - Script finished >> "%LOGFILE%"
echo Installation complete.
echo Logs saved to:
echo   %LOGFILE%
echo   %MSI_LOG%
exit /b 0
